using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;

namespace PI.ZB.N1200.ELearning.WebApplication
{
    public class Instructor : Gemini.Core.WebApplication.Base.WebPageComponent
    {

        public Instructor(Gemini.Core.WebApplication.Interface.IWebPageComponentParam WebPageComponentParam): base(WebPageComponentParam){}

        private BL.ZSBELearning _blELearning = null;
        public BL.ZSBELearning BLELearning
        {
            get
            {
                if (_blELearning == null)
                {
                    _blELearning = new PI.ZB.N1200.ELearning.BL.ZSBELearning(Environment);
                }
                return _blELearning;
            }
        }

        private bool _instructorRestored = false;
        private BL.BO.Instructor _instructor = null;
        public BL.BO.Instructor BOInstructor
        {
            get
            {
                if (!_instructorRestored)
                {
                    _instructor = BLELearning.Instructor.RestoreByUser(Environment.User);
                    _instructorRestored = true;
                }
                return _instructor;
            }
        }

        public override long ClientID
        {
            get { return BLELearning.ClientID; }
        }

        public override bool Save()
        {
            return true;
        }

        public override void Load()
        {
            try
            {
                if (WebPageEngine.IsUserAuthorized)
                {
                    if (BOInstructor == null)
                    {
                        return;
                    }

                    PI.FM.N001.Account.BL.BO.User _user = Environment.User as PI.FM.N001.Account.BL.BO.User;
                    if (_user != null)
                    {
                        XML.Element.Start("User");
                        XML.Element.Attribute("CountLogin", _user.CountLogin);
                        XML.Element.Attribute("DateLastInvalidLogin", _user.DateLastInvalidLogin, Gemini.Utility.Normalize.DateTimeFormatType.Full);
                        XML.Element.Attribute("DateLastLogin", _user.DateLastLogin, Gemini.Utility.Normalize.DateTimeFormatType.Full);
                        XML.Element.End();
                    }

                    XML.Element.Add("InstructorUser", 1);

                    XML.Element.Start("Instructor");
                    XML.Element.Attribute("Email", BOInstructor.Email);
                    XML.Element.Attribute("Forename", BOInstructor.Forename);
                    XML.Element.Attribute("ID", BOInstructor.ID);
                    XML.Element.Attribute("SchoolID", BOInstructor.SchoolID);
                    XML.Element.Attribute("Surename", BOInstructor.Surename);
                    XML.Element.Attribute("Tel", BOInstructor.Tel);
                    XML.Element.Attribute("Title", BOInstructor.Title);
                    XML.Element.End();

                    BL.BO.School _school = BLELearning.School.Restore(BOInstructor.SchoolID);
                    XML.Element.Start("School");
                    XML.Element.Attribute("AddressLine1", _school.AddressLine1);
                    XML.Element.Attribute("AddressLine2", _school.AddressLine2);
                    XML.Element.Attribute("Email", _school.Email);
                    XML.Element.Attribute("Fax", _school.Fax);
                    XML.Element.Attribute("ID", _school.ID);
                    XML.Element.Attribute("Name", _school.Name);
                    XML.Element.Attribute("PostCode", _school.PostCode);
                    XML.Element.Attribute("Tel", _school.Tel);
                    XML.Element.Attribute("Town", _school.Town);
                    XML.Element.End();
                }
            }
            catch (Exception _exception)
            {
                Gemini.Utility.Debug.SendExeptionViaEmali(Environment.ProjectName,_exception, String.Format("{0}{1}", Environment.Domain, Environment.URL));
                throw _exception;
            }
        }

        public override bool IsValid
        {
            get { return  ((WebPageEngine.IsUserAuthorized) && (BOInstructor != null)); }
        }

        public override bool IsParamKey(long ParamKey)
        {
            return false;
        }

        public override object GetParamKey(long ParamKey, params object[] Params)
        {
            return null;
        }
    }
}